.cseg
; ***********************************************************************************************
;	Port-Definitionen			(c) 2024 by DC7GB unter: BY-NC-SA 4.0
; ***********************************************************************************************


; -------
; Port A:
; -------

.equ	DRA		= 0b00000100
.equ	PULUPA		= 0b00000100
.equ	ADC0		= PA0		; (20) ---: Analog-Eingang (bipolar)
.equ	ADC1		= PA1		; (19) ---: 2,5V Mittenspannung
.equ	LED		= PA2		; (18) OUT: LED-Ausgang
.equ	_UNUSEDPA3	= PA3		; (17) ANA: Ref-Input
.equ	_UNUSEDPA4	= PA4		; (14) ---:
.equ	_UNUSEDPA5	= PA5		; (13) ---:
.equ	_UNUSEDPA6	= PA6		; (12) ---:
.equ	_UNUSEDPA7	= PA7		; (11) ---:


; -------
; Port B:
; -------

.equ	DRB		= 0b00011100
.equ	PULUPB		= 0b11100000
.equ	_UNUSEDPB0	= PB0		; (1) ---: (MOSI)
.equ	_UNUSEDPB1	= PB1		; (2) ---: (MISO) 
.equ	PRMOUT_N	= PB2		; (3) OUT: (SCK) /PDMOUT
.equ	PDMOUT		= PB3		; (4) OUT: PDM-Signal
.equ	TEST		= PB4		; (7) OUT: Testausgang
.equ	J3		= PB5		; (8) INP: Modulaton: H=extern / L=Test-Sinus m=0,5
.equ	J2		= PB6		; (9) INP: *** ohne Verwendung ***
.equ	RESET		= PB7		; (10) RESET


; ***********************************************************************************************
;	System-Konstantendefinitionen
; ***********************************************************************************************

;---------------------------------------
; Systemflags 0

.equ	TIMER		= 0		; 0= Timer luft / 1= Timer abgelaufen
.equ	F0_1		= 1		; 0= 
.equ	F0_2		= 2		; 0= 
.equ	F0_3		= 3		; 0= 
.equ	ACK		= 4		; 0= 
.equ	F0_5		= 5		; 0= 
.equ	F0_6		= 6		; 0=
.equ	F0_7		= 7		; 0= 

; -------------------------------------
; Bit-Codes

.equ	BIT0		= 0
.equ	BIT1		= 1
.equ	BIT2		= 2
.equ	BIT3		= 3
.equ	BIT4		= 4
.equ	BIT5		= 5
.equ	BIT6		= 6
.equ	BIT7		= 7

; -------------------------------------
; Zeiten und Zhler

.equ	SYSTAKT		= 16000000		; Taktfrequenz in Hz (wegen PLL-Takt!)
.equ	ADCTAKT		= 40000			; 40kHz ADC-Abtastfrequenz
.equ	TICS0		= (SYSTAKT/8)/ADCTAKT-1	; = 24 (25) mit Vorteiler 8

; -------------------------------------
; Konstanten

.equ	PDMAX		= 1023		; 10 Bit Zhlermaximum
.equ	SINSAMP		= 40		; Anzahl der Sinus-Samples in der Tabelle
.equ	TIME10MS	= 90		; 111,5s Tics fr 10ms
.equ	OFFSET		= 511		; ADC-Offset bipolar --> unipolar
.equ	LEDDELAY	= 40		; 400ms LED-Anzeige bei Overflow
.equ	LEDONOFF	= 20		; 200ms On/Off-Blinken nach PowerOn
.equ	DEADH		= 4		; PCK = (4 * 1) / 64MHz = 62,5ns 
.equ	DEADL		= 4		; PCK = (4 * 1) / 64MHz = 62,5ns 


; ***********************************************************************************************
;	System-Variablendefinition
; ***********************************************************************************************

; Variablen in CPU-Registern
; --------------------------

; ----------------------------------------------
; Register:

.def	akku0		= r0		; Artihmetik-
.def	akku1		= r1		; ...Buffer
.def	akku2		= r2		; ...fr
.def	akku3		= r3		; ...Rechnungen
.def	akku4		= r4
.def	akku5		= r5
;
.def	tics		= r15		; durchlaufender 10ms-Zhler
;
.def	temp		= r16		; *** allgemeines Hilfsregister
.def	counter		= r17		; *** allgemeiner Zhler
.def	buffer		= r18		; *** allgemeiner Buffer
;
.def	t25us		= r19		; 100s-Zhler
.def	t10ms		= r20		; 10ms-Zhler
.def	squarecnt	= r21		; Zhler fr Rechteckperiode
;
.def	flags0		= r22		; Systemnflags

; ----------------------------------
; Ab r26 Doppelbelegung mit X, Y, Z
; ----------------------------------

